# How to contribute

Community made patches, localisations, bug reports and contributions are always welcome and are crucial to ensure WooSidebars remains the #1 widget area management plugin for WordPress. ;)

When contributing please ensure you follow the guidelines below so that we can keep on top of things.

__Note:__

GitHub is for *bug reports and contributions only* - if you have a support question or a request for a customization, don't post here. Use [WooThemes Support](http://support.woothemes.com) for customer support, [WordPress.org](http://wordpress.org/support/plugin/woosidebars) for community support, and for customisations we recommend one of the following services:

- Codeable: http://codeable.io/
- Tweaky: https://www.tweaky.com/
- Affiliated Woo Workers: http://www.woothemes.com/affiliated-woo-workers/

## Getting Started

* Make sure you have a [GitHub account](https://github.com/signup/free)
* Submit a ticket for your issue, assuming one does not already exist.
  * Clearly describe the issue including steps to reproduce when it is a bug.
  * Make sure you fill in the earliest version that you know has the issue.

## Making Changes

* Fork the repository on GitHub.
* Make the changes to your forked repository.
  * **Ensure you stick to the [WordPress Coding Standards](http://codex.wordpress.org/WordPress_Coding_Standards).**
  * Ensure you use LF line endings - no crazy windows line endings. :)
* When committing, reference your issue (#1234) and include a note about the fix.
* Push the changes to your fork and submit a pull request on the latest release branch of the WooSidebars repository.
  * Release branches start their branch name with `release-`.

At this point you're waiting on us to merge your pull request. We'll review all pull requests, and make suggestions and changes if necessary.

# Additional Resources

* [General GitHub documentation](http://help.github.com/)
* [GitHub pull request documentation](http://help.github.com/send-pull-requests/)
* [WooSidebars Docs](http://docs.woothemes.com/documentation/plugins/woosidebars/)
* [WooThemes Support](http://support.woothemes.com/)